lection = room {
	nam = 'سخنرانی بلین',
	pic = 'gfx/lection.png',
	dsc = [[می‌شنم سر جام... همه چیز رو به وضوع از اینجا می‌شنوم. بذار به فیزیکدان مشهور گوش کنیم...
	^^- در نوامبر ۱۹۳۵ شرودینگر مقاله‌اش را که آزمایش زیر را در آن شرح داده بود منتشر کرد. هدف یک آزمایش چیست؟ - بلین برای لحظه‌ای مکث کرد و یک جعبه‌ی عجیب را روی میز گذاشت.
	- من آزمایش را دوست دارم! - لبخند سفید بلین ناگهان پدیدار شد.
	- همینطور که می‌بینید این یک جعبه است... - بلین با دستش ضربه‌ای به سطح صاف جعبه زد.
	- این جعبه یک محفظه‌ی توکار حاوی گاز سمی دارد. علاوه بر این، این جعبه حاوی یک شمارشگر گایگر و یک ماده‌ی پرتوزا و یک تایمر است.
	پارامترهای این آزمایش به گونه‌ای تنظیم شده‌اند تا احتمال واپاشی ماده‌ی پرتوزا طی یک ساعت ۵۰ درصد باشد.^^
	- چنانچه واپاشی روی دهد، مکانیزم جعبه فعال می‌شود و گاز سمی آزاد شده و وارد فضای داخل جعبه  می‌شود. بنابراین، آقایان، به گمانم که قضیه تا اینجا ساده است. اینطور نیست؟ - بلین دوباره لبخند می‌زند.
	- اما نکته اینجاست که طی این آزمایش شرودینگر یک گربه داخل جعبه قرار می‌دهد. - یک موجود زنده.^^
	- بنابر نظریه‌ی کوانتوم، اگر ما مشغول تماشای هسته‌ی اتم باشیم - وضعیت هسته برابر است با برهم‌نهی (سوپرپوزیشن یا میکس) دو حالت مختلف - حالت اتم با واپاشی و حالت اتم بدون واپاشی. بنابراین، گربه‌ی درون جعبه همزمان هم زنده و هم مرده است.
	- بلین صدایش را بلند می‌کند.
	- البته ما می‌توانیم بگوییم که این تنها یک سرگرمی فکری است. اما من نشان خواهم داد و ثابت خواهم کرد که اینگونه نیست...^^
	
	- پس اگر آزمایشگر جعبه را باز کند، اون تنها یکی از دو حالت یاد شده را مشاهده خواهد کرد: «واپاشی روی داده و گربه مرده است» و یا «واپاشی روی نداده و گربه زنده است.» شرودینگر فکر می‌کرد که این تناقض ناپایداری نظریه مکانیک کوانتومی را ثابت می‌کند. اما ما همگی می‌دانیم که مکانیک کوانتومی فی‌الواقع چهره‌ی واقعی جهان ماست!
	- بلین دوباره صدایش را بلند می‌کند.
	- و بنابراین، مستقل از یکدیگر (که این تا حدودی صحت قضیه را اثبات می‌کند)، هانس موراوک در سال ۱۹۸۷ و نیز برونو مارشال در سال ۱۹۸۸ موقعیت را از منظر گربه مورد توجه قرار دادند!^^
	
	- چنانچه برداشت چندجهانی اِوِرِت صحیح باشد، هربار که آزمایش گربه انجام می‌شود، جهان به دو جهان مجزا تقسیم می‌شود. در جهان اول گربه زنده است و در جهان دوم مرده. گربه در جهانی که مرده است از بودن دست می‌کشد. از سوی دیگر، از نگاه گربه‌ای که زنده است آزمایش ادامه دارد و منجر به مرگ گربه نمی‌شود. این صحت دارد چرا که در هر یک از حالات گربه تنها قادر به مشاهده‌ی آزمایشی است که در آن جهانی جریان دارد که گربه در آن زنده مانده است. و چنانچه تفسیر چندجهانی صحت داشته باشد، گربه تنها می‌تواند ببیند که هرگز نمرده است...
	- بلین مکث می‌کند و به حضّار نگاه می‌کند.^^
	
	- معنای این چه می‌تواند باشد آقایان؟ من از شما می‌پرسم، این چه معنایی دارد؟ بیایید تصور کنیم که مشاهده‌گر آزمایش یک بمب اتمی در نزدیکی خویش منفجر می‌کند. بنابر تفسیر چندجهانی مشاهده‌گر خودش را تقریبا در تمامی دنیاهای موازی نابود می‌کند. ولی علی‌رغم این واقعیت، تعداد اندکی جهان موازی باید وجود داشته باشد که آزمایشگر در آنها به شیوه‌ای زنده می‌ماند. و ما به این ایده می‌رسیم... - بلین صدایش را بار دیگر بلند می‌کند. - ایده‌ی جاودانگی کوانتومی!!!^^
	
	- ایده‌ی جاودانگی کوانتومی آنست که مشاهده‌گر زنده می‌ماند و قادر به مشاهده‌ی هستی است، حداقل در یکی از جمیع جهان‌ها، حتی اگر تعداد بسیار اندکی از این (خجسته) جهان‌ها وجود داشته باشد. بدین‌ترتیب، در نهایت مشاهده‌گر درخواهد یافت که او می‌تواند برای همیشه زنده بماند!!!^^
	
	- همه ما تمام سال را به سختی کار کرده‌ایم، تحت هدایت رهبریِ عالیِ...
	- در این لحظه بلین نگاهی به پرتره‌ها انداخت.
	- و من باید به شما بگویم، آقایان، که ما معلومات کافی در مرکز رسانه‌ای‌مان داریم...
	- بلین نگاهی به سقف انداخت.
	- معلومات کافی تا ثابت کنیم، تکرار می‌کنم، تا به صورت علمی چه در تئوری و چه در آزمایش درستی فرضیه‌ی چندجهانی را ثابت کنیم...^^
	
	- اما این برای ما چه معنایی خواهد داشت؟ شما قادر به مشاهده‌ی آن نیستید اما... - بلین نگاهی به ساعتش انداخت - اما در چند دقیقه‌ی آتی قطار حاوی اورانیوم به دروازه‌ی پشتی موسسه می‌رسد... به قدری اورانیوم خواهد بود که بتوان به هر یک از شما یک بمب هسته‌ای داد. از جایی که به زودی یقین حاصل خواهید کرد که جاودانگی کوانتومی حقیقت محض است، هر یک از شما به یک هراس‌افکن شکست‌ناپذیر تبدیل خواهد شد!!! جهان به چندین جهان منشعب خواهد شد، جایی که شما - بلین با انگشت به حضار اشاره می‌کند - شما به فرمانروای مطلق و ارباب آن تبدیل خواهید شد!!! - بلین تقریبا این را فریاد زد...^^
	
	حضار در برابر این خطابه تاب تحمل از کف دادند. همه بلند شدند و کف زدند... در چشمایشان شعله‌ای اهریمنی می‌سوخت... خدای من! این یک جور وهمه! - با خودم فکر کردم... پاهام در اختیار خودم نبودن. سر جام نشسته بودم و قادر به حرکت نبودم...^^
	
	- بگذارید به نکته اصلی برگردیم. - بلین گفت. - بیایید آزمایشمان را دنبال کنیم. - همزمان با گفتن این کلمات او یک موجود زنده را از زیر میز برداشت.. آن موجود باریسک من بود...
	- خیلی خوب، حالا من این گربه را داخل جعبه می‌گذارم و ما همگی خواهیم دید که او چگونه... - جلو چشم‌هام رو خون گرفت...
	]],
	enter = function(s)
	-- end of episode 2
		eside = nil;
		moika = nil;
		eating = nil;
		kitchen = nil;
		stolcorridor = nil;
		entrance = nil;
		floor2 = nil;
		eroom = nil;
		room33 = nil;
		room3x = nil;
		cor3 = nil;
		toilet3 = nil;
		floor3 = nil;
		toilet = nil;
		toiletw = nil;
		room4x = nil;
		room46 = nil;
		hall42 = nil;
		hall41 = nil;
		floor4 = nil;
		floor5 = nil;
		povardlg = nil;
		kitchendlg = nil;
		facectrl = nil;
	end,
	act = function(s, w)
		if w == 1 then
			set_music("mus/under.s3m");
			return walk('escape1');
		end
	end,
	obj = {
		vobj(1, 'next', '{Next}.'),
	};
};

profdlg = dlg {
	nam = '!!!',
	pic = 'gfx/me.png',
	dsc = 'زورم رو جمع می‌کنم، بلند می‌شم و با همه وجودم فریاد می‌زنم...',
	obj = {
		[1] = phr('دختر نیست، پسره!', 
	'بلین دستش رو نگه می‌داره. نگاهش به منه. منو شناخته!! - حراست! فرد غیرمجاز داخل سالن!!! از اینجا بی... بیرونش کنید!!! - داد می‌زنه.',
	[[poff(2);escape1.obj:add('guardian')]]),
		[2] = phr('به گربه‌ی من دست نزن!', 
	'بلین دست نگه می‌داره و تو چشمام نگاه می‌کنه. صورتش بهت‌زده است. - نگهبان‌ها!!! نگهبان‌ها!!! فرد غیرمجاز داخل سالن!!!',
	[[poff(1);escape1.obj:add('guardian')]]),
	},
};

profdlg2 = dlg {
	nam = 'بلین',
	pic = 'gfx/prof2.png',
	dsc = 'بلید مثل گچ سفید شد. مات و مبهوت به شاتگان خیره شد.',
	obj = {
		[1] = phr('به خاطر گربه‌ام اومدم!', 
	'باریسک رو از دست بلین می‌گیرم و می‌ذارمش تو بغلم.',
		[[inv():add('mycat'); lifeon('mycat')]]),
		[2] = phr('بهشون بگو برن بیرون!!!',
	'بلید صورتش سفیده سفیده. ظاهرا نمی‌فهمه من چی می‌گم...',
		[[pon(3)]]),
		[3] = _phr('زودباش!!! بهشون بگو ازینجا برن بیرون...', 
		'تکونش می‌دم. بلین چیزی حس نمی‌کنه. فقط به لوله‌های سیاه شاتگان خیره شده.',
		[[pon(3); back();]]);
	},
};
gdlg1 = dlg {
	nam = 'نگهبان',
	pic = 'gfx/guard42.png',
	dsc = 'سر نگهبان داد می‌زنم. صدام به نظرم غیرعادی میاد...',
	obj = {
	[1] = phr('اسلحه‌ات رو سر و ته بذار روی میز و هلش بده طرف من...',
		'نگهبان با بی‌قراری به من نگه می‌کنه...',
		[[pon(2)]]),
	[2] = _phr('گفتم تفنگ روی میز!!! — لوله‌ها رو محکم‌تر به سینه‌ی بلین فشار می‌دم. چیزی نمونده از حال بره.',
	'نگهبان خیلی با دقت تفنگش رو می‌ذاره روی میز و هلش می‌ده طرف من... سریع برش می‌دارم. حالا دو تا تفنگ تو هر دو دستم دارم.',
		[[pon(3); inv():add('shotgun')]]),
	[3] = phr('از صورت من خوشت نیومد؟ نه؟؟؟',
		'نگهبان سکوت می‌کنه. پیشونیش عرق کرده...',
		[[pon(3); back();]]),
	};
};

shotgun = obj {
	nam = 'شاتگان نگهبان',
	inv = 'یه شاتگان با گلنگدن دستی... برای شش فشنگ. جالبه، چند تا فشنگ توش هست؟',
	dsc = '{شاتگان} افتاده روی زمین.',
	tak = function(s)
		if s._unloaded then
			return 'نیازی بهش ندارم. مهمات نداره.', false
		end
		return 'شاتگانم رو پس می‌گیرم.';
	end,
};

guardian = obj {
	nam = 'نگهبان',
	dsc = function(s, w)
		if not professor._gun then
			return '{نگهبان} رو می‌بینم که با یه شاتگان آهسته و مصمم به طرفم میاد.';
		end
		if have('shotgun') then
			return '{نگهبان} بی سلاح رو می‌بینم. با دقت داره من رو نگاه می‌کنه.';
		end
		return '{نگهبان} رو می‌بینم که تفنگش رو شل گرفته.';
	end,
	act = function(s, w)
		if not professor._gun then
			return 'به زودی گیرم می‌اندازه...';
		end
		return walk('gdlg1');
	end,
	used = function(s, w)
		if w == 'shotgun' then
			return 'نه، نمی‌تونم خودم رو راضی به انجامش بکنم...';
		end
		if w == 'gun' then
			if not professor._gun then
				return 'شاتگان کوتوله‌ی من مناسب فواصل طولانی نیست...';
			end
			return 'تو این وضعیت باید تفنگم رو به طرف بلین نشونه برم. ضمنا اگه شلیک کنم باید دوباره پرش بکنم...'; 
		end
	end
};

professor = obj {
	nam = 'بلین',
	dsc = function(s, w)
		if not s._gun then
			return '{بلین} جلوی تخته ایستاده و باریسک من رو گرفته دستش.';
		end
		return 'هر دو لول شاتگان رو می‌گیرم رو سینه‌ی {بلین}.';
	end,
	act = function(s)
		if not s._gun then
			return walk('profdlg');
		end
		return walk('profdlg2');	
	end,
	used = function(s, w)
		if w == 'gun' then
			if s._gun then
				return 'سینه‌ی بلین رو با شاتگان با شدت بیشتری فشار می‌دم.';
			end
			s._gun = true;
			objs():add('guardian');
			gun._hidden = false;
			return 'شاتگان کوتاه‌شده‌ام رو از کتم درمیارم، می‌پرم روی میز و می‌دوم طرف بلین.';
		end
	end,
};

pdlg = dlg {
	nam = 'حضار',
	pic = 'gfx/me.png',
	dsc = 'به حضار نگاه می‌کنم و فریاد می‌زنم...',
	obj = {
		[1] = phr('دروغه!!! هیچ سند علمی برای اثبات این ادعا نیست!!!',
			'— بهت...',[[pon(2)]]),
		[2] = _phr('جهان یکتاست!!! هر یک از شما این رو از بچکی می‌دونه!!! از اینجا برین!! از این کالت خودتون رو نجات بدین!!!', 
		' - جواب سکوت بود...'),
		[3] = phr('یه گله گوسفند نادون!!! چطور می‌تونید به این سادگی خام بشید؟',
			'- صدا ازشون درنمیاد و من هم از نگاهشون خوشم نمیاد...',
			[[pon(3); back();]]),
	},
};

narod = obj {
	nam = 'حضار',
	dsc = function(s)
		if not professor._gun then
			if seen('guardian') then
				return '{افراد} داخل سالن نگاه‌های پرسشگرشون رو دوختن به من. تو شک و تردید هستن.';
			end
			return '{افراد} داخل سالن دارن بلین رو نگاه می‌کنن.';
		end
		return '{افراد} تو سالن سر جاشون خشکشون می‌زنه. همه به من خیره شدن. دست از پا خطا کنم مردم... و همه‌ی دنیا هم... مرده...';
	end,
	act = function(s)
		if professor._gun then
			return walk('pdlg');
		end
		if seen('guardian') then
			return 'فعلا که به من حمله نکردن... تا اینجا که خوبه...';
		end
		return 'متعصبین دیوانه! همشون دیوانه هستن...';
	end,
	used = function(s, w)
		if w == 'gun' or w =='shotgun' then
			return 'به گمونم فشنگ کافی ندارم.';
		end
		return 'هیهات...';
	end
};

win = obj {
	nam = 'پنجره',
	dsc = function(s)
		local st = '';
		if s._broken then
			st = 'یه پنجره شکسته.';
		end
		return 'سه {پنجره‌ی} پهن غربی.'..st;
	end,
	act = 'بیرون تاریکه. هیچی به جز دونه‌های برف که به پنجره می‌خورن نیست.';
	used = function(s, w)
		if w ~= 'gun' and w ~= 'shotgun' then
			return 'دردی رو دوا نمی‌کنه...';
		end
		if s._broken then
			return 'از قبل شکسته...';
		end
		if not have('shotgun') then
			return 'نگهبان بهم شلیک می‌کنه.';
		end
		s._broken = true;
		ways():add('window');
		return 'با قنداق شاتگان نزدیکترین پنجره رو می‌شکنم...';
	end	
};

escape1 = room {
	nam = 'سالن ۲',
	dsc = 'داخل سالنم. حضار اینجا منتظر ادامه‌ی آزمایش هستن.',
	pic = function()
		if professor._gun then
			return 'gfx/meandgun.png';
		end
		return 'gfx/lection2.png';
	end,
	obj = {
		'win',
		vobj(4, 'lamps', 'سالن توسط نور {مهتابی} روشن شده.'), 
		'professor',
		'narod',
		vobj(5, 'box', '{جعبه} روی میزه.'),
		'portrait',
	},
	act = function(s, w)
		if w == 5 then
			return 'جعبه‌ی لعنتی...';
		end
		if w == 4 then
			return 'شش تا لامپ... از این نور سوسوزن متنفرم...';
		end
	end,
	used = function(s, w, ww)
		if ww == 'gun' or ww == 'shotgun' then
			if not professor._gun then
				return 'بهتره اینکار رو نکنم...';
			end
			if w == 4 then
				return 'تاریکه فقط به من نیست که کمک می‌کنه، بلکه به اونها هم. و اونها تعدادشون بیشتره.';
			end
			if w == 5 then
				return 'سم هنوز اونجاست. نمی‌خوام باریسکم چیزیش بشه.';
			end
		end
	end,
	exit = function(s, t)
		if t == 'window' and not have('mycat') then
			return 'پس باریسک چی می‌شه؟', false
		end
		if t == 'cor4' then
			return 'باید فورا کاری بکنم!', false;
		end
	end,
	way = { 'cor4' },
};
lest = obj {
	nam = function(s, w)
		if s._seen then
			return 'نردبان';
		else
			return 'یه چیز';
		end
	end,
	dsc = function(s, w)
		if s._seen then
			return 'توی بوران به سختی می‌تونم {نردبان} فرار اضطراری رو تشخیص بدم!';
		end
		return 'توی بوران می‌تونم شبح یک {سازه‌ای} رو تشخیص بدم.';
	end,
	act = function(s, w)
		if not s._seen then
			ways():add('ladder');
			s._seen = true;
			return 'نردبون فرار اضطراریه!!!';
		end
		return 'پریدن یا نپریدن، مسئله اینست...';
	end,
};

window = room {
	nam = function(s)
		if here() == window then
			return 'رو آستانه‌ی پنجره';
		end
		return 'به طرف پنجره';
	end,
	pic = 'gfx/fromwin1.png',
	enter = 'می‌دونم که زده به سرم، اما می‌دوم به طرف پنجره... همهمه‌ی جمعیت رو پشت سرم می‌شنوم...';
	dsc = 'رو آستانه‌ی پنجره می‌ایستم و زل می‌زنم به دل سیاهی شب.',

	obj = {
		'lest',
	},
	exit = function(s, t)
		if t == 'escape1' then
			return 'نمی‌تونم برگردم... دیوانه‌ها اونجان...', false;
		end
	end,
	way = { 'escape1',},
};


down = room {
	nam = 'پایین';
};

window5 = obj {
	nam = 'پنجره',
	dsc = function(s, w)
		if s._broken then
			return 'یه {پنجره} شکسته سمت چپ منه';
		end
		return 'یه نور زرد از یه {پنجره} کنارم داره میاد.';
	end,
	act = function(s)
		if not s._broken then
			return 'پنجره بسته است...';
		end
		return walk('room5');
	end,
	used = function(s, w)
		if w == 'gun' or w == 'shotgun' then
			if s._broken then
				return 'از قبل شکسته...';
			end
			s._broken = true;
			return 'با قنداق شاتگان شیشه رو می‌شکنم... خرده شیشه‌ها تو دل شب پخش می‌شن...';
		end
	end
};


up = room {
	_num = 0;
	nam = 'بالا',
	enter = function(s, w)
		s._num = s._num + 1;
		if s._num == 2 then
			lifeon('ladder');
			return 'ناگهان سیاهی شب رو نور پروژکتورها کنار می‌زنن و سکوت هم با صدای آژیر شکسته می‌شه... ظاهرا از پایین من رو دیدن...', false;
		end
		if s._num > 4 then
			ladder.way:del('up');
			ladder.obj:add('window5');
		end
		return 'دارم آروم می‌رم بالا...', false;
	end
};

ladder = room {
	nam = 'نردبان',
	pic = 'gfx/ladder.png',
	dsc = [[
	روی نردبون سرد هستم. دونه‌های تیز برف صورتم رو خراش می‌دن.]],

	act = function(s, w)
		if w == 1 then
			return [[
			اگه نجنبم به زودی یخ می‌زنم...]];
		end
	end,
	obj = {
		vobj(1, 'ladder rails', '{پله‌های} آهنی نردبون رو گرفتم.'),
	};
	enter = function(s)
		inv():del('gun');
		return [[
		دورخیز می‌کنم و می‌پرم... برای چند ثانیه دلم هرّی می‌ریزه، اما گرمای باریسک رو تو بغلم حس می‌کنم و فورا فولاد سیاه رو می‌گیرم... شاتگان از رو دوشم می‌افته پایین...]];
	end,
	way = { 'up', 'down' },
	life = function(s)
		if rnd(2) == 1 then
			return 'سر و صدای شلیک مسلسل‌ها رو می‌شنوم - چندین گلوله به نزدیکی من می‌خورن...';
		end
	end,
	exit = function(s, t)
		if t == 'down' then
			if s._shoot then
				return [[
هم من رو می‌کشن... و هم باریسک من رو... و دنیا رو نابود می‌کنن...]], false;
			end
			lifeon('ladder');
			s._shoot = true;
			return [[
			همینکه مشغول پایین اومدن شدم، پرتو یک نورافکن سیاهی شب رو شکافت و زوزه‌ی یک آژیر آرامش شب رو به هم ریخت... ظاهرا از پایین من رو دیدن...]]
			, false;
		end
		if t ~= 'up' then
			lifeoff('ladder');
		end
	end
};

hand = obj {
	nam = 'دست خونی',
	inv = 'دستم داره خونریزی می‌کنه... فکر کنم از هوش برم...',
	life = 'قطره‌های خون داره از دستم روی زمین می‌چکه...',
	used = function(s, w)
		if w == 'galstuk' then
			inv():del('galstuk');
			inv():del('hand');
			lifeoff('hand');
			return 'با کراوات دستم رو باندپیچی می‌کنم... تا اینجا که خوبه...';
		end
	end
};

computers = obj {
	nam = 'کامپیوترها',
	dsc =[[
	بیشتر فضا رو رک‌های بلند حاوی {سخت‌افزار} کامپیوتر اشغال کردن. وزوز آروم فن‌ها به گوش می‌رسه. لامپ‌های کوچک شبکه با هول و ولا چشمک می‌زنن.
	]];
	act = function(s)
		if kover._fire then
			return 'عجالتا بسوزید ماشینهای خبیث!!! بسوزید!!! دیگه وقتشه بزنم به چاک.';
		end
		return [[
		این سخت‌افزارها شرارت انبار می‌کنن... باید همه رو نابود کنم، اما چطور؟ از زندگی سابقم می‌دونم که بهترین روش برای از بین بردن دیسک‌های مغناطیسی اینه که درجه حرارتش رو برسونیم به نقطه کوری. به عبارت دیگه باید همه این کامپیوترهای لعنتی رو بسوزونم!!! اما چطور آتش درست کنم؟
		]];
	end,
	used = function(s, w)
		if w == 'shotgun' then
			return 'به سرورها شلیک کنم؟ خیلی قابل اطمینان نیست... باید این خباثت رو بسوزونم...';
		end
	end
};

poroh = obj {
	nam = 'باروت',
	inv = 'این باروت باید بدردم بخوره.',
};

trut = obj {
	nam = 'آتشزنه',
	inv = 'یه تیکه کاغذ و باروت. به گمونم آتشزنه ساختم!!!',
	use = function(s, w)
		if w == 'ibp' and ibp._knife and not ibp._trut then
			ibp._trut = true;
			inv():del('trut');
			return 'آتشزنه رو می‌ذارم روی منبع برق بی وقفه.';
		end
	end
};

fire = obj {
	nam = 'آتش',
	inv = 'کاغذ فورا آتش می‌گیره... باید بی درنگ کاری بکنم!!!',

	use = function(s, w)
		if w == 'poroh' then
			return 'تو دستم می‌ترکه.';
		end
		if w == 'news' then
			return 'یه تکه دیگه از روزنامه رو پاره می‌کنم. از شعله آتش می‌گیره..';
		end
		inv():del('fire');
		if w ~= 'kover' then
			return 'کاغذ خاکستر می‌شه و از بین می‌ره...';
		end
		if kover._fire then
			return 'کاغذ رو پرت می‌کنم روی فرش شعله‌ور...';
		end
		kover._fire = true;
		return 'کاغذ رو می‌ذارم روی فرش... تار و پود فرش شروع به سوختن می‌کنه... مثل اینکه داره آتیش می‌گیره...';
	end
};

ibp = obj {
	nam = 'UPS',
	dsc = 'یه {UPS} باز شده روی زمینه.',
	inv = function(s)
		if not s._knife then
			return 'این یه واحد برق بدون وقفه است. باهاش چی کار کنم؟';
		end
		local st = '';
		if s._trut then
			st = ' کاغذ و باروت روی باطریه.';
		end
		return 'یو‌پی‌اس پیاده شده. اتصالات منتهی به باطری رو می‌بینم...'..st;
	end,
	act = function(s)
		if not have('ibp') then
			if not have('fire') and not kover._fire then
				take('ibp');
				return 'یو‌پی‌اس رو دوباره برمی‌دارم.';
			end
			return 'دیگه بهش احتیاج ندارم.';
		end
		return s:inv();
	end,
	used = function(s, w)
		if not have('ibp') then
			return 'این کار نمی‌کنه...';
		end
		if w == 'knife' then
			s._knife = true;
			return 'پیچ‌ها رو باز می‌کنم و یو‌پی‌اس رو پیاده می‌کنم. حالا اتصالات منتهی به باطری رو می‌بینم...';
		end
		if w == 'provodki' and s._knife then
			if not provodki._knife then	
				return 'سیم‌ها لخت نیستن.';
			end
			if not s._trut then
				return 'سیم‌ها رو به ترمینال‌های باطری وصل می‌کنم و یه اتصال کوتاه می‌سازم. جرقه می‌زنه. یه آتشزنه لازم دارم...';
			end
			drop('ibp');
			ibp._trut = false;
			inv():add('fire');
			return 'سیم‌ها رو به ترمینال‌های باطری وصل می‌کنم و یه اتصال کوتاه می‌سازم. جرقه می‌زنه و آتشزنه آتش می‌گیره! حالا آتیش دارم!!!';
		end
		if w == 'provod' then
			return 'کابل رو وارد UPS کردم و بیرون کشیدم... عجب...';
		end
	end,
};

provodki = obj {
	nam = 'سیم نازک',
	inv = function(s)
		if s._knife then
			return 'یک جفت سیم نازک با لبه‌های برش خوره.'
		end
		return 'یک جفت سیم نازک.'
	end,
	used = function(s, w)
		if w == 'knife' and not s._knife then
			s._knife = true;
			return 'عایق لبه‌های سیم رو می‌چینم و سیم لخت رو آزاد می‌کنم.';
		else
			return 'نمی‌شه...';
		end
	end
};

provod = obj {
	nam = 'سیم UPS',
	inv = 'این سیم UPS است.',
	used = function(s, w)
		if w == 'knife' then
			if not knife._oster then
				return 'لبه چاقو خیلی کنده...';
			end
			inv():del('provod');
			inv():add('provodki');
			return 'لایه عایق اصلی رو می‌برم و دو تا سیم بیرون می‌کشم'
		end
	end
};

ups = obj {
	nam = 'ups',
	dsc = 'در مجاورت هر رک یک {منبع برق بی وقفه} قرار گرفته.',
	act = function(s)
		if have('hand') then
			return 'دستم زخمی شده. بدجور خونریزی می‌کنه. نمی‌تونم یه UPS بردارم.';
		end
		if not have('ibp') and not seen('ibp') then
			inv():add('ibp');
			inv():add('provod');
			return [[
			بعد از کلی زحمت یکی از UPS ها رو قطع می‌کنم و برش می‌دارم...
			]];

		end
		return 'از قبل یکی دارم.';
	end,
};

kover = obj {
	nam = 'فرش',
	dsc = function(s)
		if s._fire then
			return '{فرش} روی زمین بیشتر و بیشتر داره می‌سوزه.';
		end
		return 'زمین با یه {فرش} قرمز پوشیده شده.';
	end,
	act = 'تجملات بی‌مصرف.',
};

room5 = room {
	nam = 'مرکز داده‌ها';
	pic = 'gfx/servers.png',
	dsc = [[
	داخل اتاق بزرگی هستم که کل محوطه‌ی جنوبی موسسه رو اشغال کرده.
	]],
	enter = function(s, f)
		if f == 'ladder' then
			set_music('mus/hybrid.xm');
			lifeon('hand');
			inv():add('hand');
			return [[
			می‌پرم و قاب پنجره رو می‌گیرم. دست راستم غرق خونه. علیرغم درد می‌پرم کف اتاق...
			]];
		end
	end,
	exit = function(s, f)
		set_music("mus/under.s3m");
	end,
	act = function(s, w)
		if w == 1 then
			return 'برنمی‌گردم... بیرون سرده و تیراندازی هم فراوان...';
		end
	end,

	obj = { 'computers', 'ups',
		vobj(1, 'window', 'باد سرد زمستون از توی {پنجره} می‌وزه.'),
		'kover',
		'dout',
		'portrait',
	},
};

dout = obj {
	nam = 'door',
	dsc = function(s)
		return 'در دوردست می‌تونم {درب} خروج رو ببینم.';
	end,
	act = function(s)
		if not kover._fire then
			return [[
			اینجا مرکز پردازش داده‌هاست. باید نابودش کنم تا بتونم دنیا رو از شر این عفونتی که درون این مخازن انبار شده نجات بدم...
			]];
		end
		return [[
		می‌دوم به طرف در. به آسانسورها منتهی می‌شه. اما قفل الکترونیکی داره!!! معنیش اینه که من یه کارت با دسترسی مناسب نیاز دارم تا بتونم بازش کنم. یعنی تو آتیش می‌سوزم؟
		]];
	end,
	used = function(s, w)
		if not kover._fire then
			return s:act();
		end
		if w == 'card' then
			return 'کارت رو می‌کشم روی در. بیپ. دسترسی غیرمجاز! همینجا می‌میرم!!!';
		end
		if w == 'shotgun' then
			return walk('escape2');
		end
		return 'کمکی نمی‌کنه...';
	end
};

handgdlg = dlg {
	nam = 'نگهبان',
	pic = 'gfx/handhoh.png',
	dsc = 'نگهبان - یه مرد جوون حدودا سی ساله - بهم نگاه می‌کنه. گیج شده.',

	obj = {
	[1] = phr('سلاحت رو بده من!',
	'- من اسلحه ندارم... - نگهبان سرش رو تکون می‌ده... نمی‌دونم که می‌تونم بهش اعتماد کنم یا نه، اما نمی‌خوام بازرسیش کنم...'),

	[2] = phr('کلید در قرمز رو لازم دارم.',
	'نگهبان رنگش می‌پره. «هیچکس کلید این در رو نداره.» با خودم فکر می‌کنم که چرند می‌گه...'),

	[3] = phr(
	'باشه! فقط بی‌حرکت بمون و از جات تکون نخور.',
	'نگهبان ساکت من رو نگاه می‌کنه.',
		[[pon(3);back();]]),
	},
};

win5 = obj {
	nam = 'window',
	dsc = function (s)
		if s._broken then
			return 'باد سرد زمستون از توی {پنجره} زوزه می‌کشه. دونه‌های برف روی زمین فر می‌خورن.';
		end
		return 'یه {پنجره‌ی} پهن غربی.';
	end,
	act = function(s)
		if not s._broken then
			return 'میام سمت پنجره... جالبه. می‌بینم که پنجره مشرف به بخش وسیعی از سقفه که تا بخش جلوی ساختمان امتداد داره...';
		end
		return 'پنجره شکسته... سومین برای امروز.';
	end,
	used = function(s, w)
		if s._broken then
			return s:act();
		end
		if w == 'shotgun' then
			s._broken = true;
			ways():add('krysha');
			return [[
			ای دریغ... سومین پنجره برای امروز... با تمام توانم تاب می‌خورم و شیشه شکسته‌ها به طرف پشت‌بام به پرواز درمیان...
			]];
		end
	end,
};

escape2 = room {
	_timer = 0,
	nam = 'محوطه‌ی طبقه پنجم',
	pic = 'gfx/floor5e.png',
	dsc = [[
	سقف طبقه پنجم خیلی بلنده.
	]],
	enter = function(s, f)
		if f == 'room5' then
			lifeon('escape2');
			return [[
			در حالی که جونی در بدنم نمونده با قنداق شاتگان می‌کوبم به در منفور. اما یکهو می‌شنوم که کسی از بیرون به طرف در میاد... یه نگهبانه!!! کارتخوان بیپ بیپ می‌کنه و در باز می‌شه. نگهبان عقب می‌ایسته - سینه‌اش رو تفنگ دست‌کش من داره به عقب فشار می‌ده. به طرف محوطه‌ی آسانسورها خارج می‌شیم.
			]];
		end
		if f == 'krysha' then
			lifeon('escape2');
		end
	end,
	life = function(s)
		s._timer = s._timer + 1;
		if s._timer == 3 then
		return [[
		یکهو صدای یه آژیر بلند شد. - توجه!!! توجه!!! فردی با سطح حفاظتی صفر در طبقه پنجم! تکرار می‌کنم... - صدا از رادیو پخش می‌شه.
		]];
		end
		if s._timer > 3 then
			return '— فردی با سطح حفاظتی صفر در طبقه پنجم!!! - حالم داره از صدای وزوز آژیر بد می‌شه.';
		end
	end,
	act = function(s, w)
		if w == 1 then
			return 'پاهام داره توی مخمل قرمز فرو می‌ره... تجملات لعنتی!';

		end
		if w == 2 then
			return 'بازم، جنسش کریستاله...';
		end
		if w == 4 then
			return 'آتیش داره گسترش پیدا می‌کنه...';
		end
		if w == 5 then
			return 'فکر نکنم کارتم اینجا کار کنه.';
		end
		if w == 6 then
			return walk('handgdlg');
		end
	end,
	used = function(s, w, ww)
		if w == 6 then
			return 'همچنان نگهبان رو نشونه می‌رم.';
		end
		if w == 5 then
			return 'کمکی نمی‌کنه.';
		end
	end,
	obj = {
	vobj(1, 'carpet', 'محوطه آسانسور با یک {فرش} قرمز پوشونده شده.'),
	vobj(2, 'chandelier', 'یه {چلچراغ} کریستال از سقف بلند آویزونه.'),
	'win5',
	vobj(4, 'information', '{درب} منتهی به مرکز پردازش داده‌ها کاملا بازه. دود داره از اونجا بیرون می‌زنه.');
	vobj(5, 'red door', '{در} مخالف هیچ عنوانی نداره. یه در عظیم چرمی قرمزه.'),
	vobj(6, 'guard', '{نگهبان} وسط محوطه ایستاده و دستهاش رو بالا گرفته.');
	},
	way = { 'lift','room5' },
	exit = function(s, t)
		if t == 'room5' then
			return 'شعله است!', false
		end
		if t == 'lift' then
			return [[
			متوجه می‌شم که نشانگر همه‌ی آسانسورها روشنه. مطمئنم که این یعنی همه نگهبان‌ها دارن میان این طرف... باید عجله کنم!
			]], false;
		end
		if t == 'krysha' then
			lifeoff('escape2');
		end
	end
};

swin = obj {
	nam = 'پنجره جنوبی',
	dsc = 'دود داره از {پنجره} جنوبی بیرون می‌زنه.',
	act = 'بله، یکی از پنجره‌های مرکز پردازش داده‌هاست. به پنجره نگاه می‌کنم و شعله رو می‌بینم.',
};

nwin = obj {
	nam = 'پنجره شمالی',
	dsc = function(s)
		local st = '';
		if s._broken then
			st = 'پنجره شکسته.';
		end
		return '{پنجره} شمالی با نور زردرنگ رو به تاریکی می‌درخشه.'..st;
	end,
	act = function(s)
		if s._broken then
			return walk('hall5');
		end
		return 'عجب... به پنجره نگاه می‌کنم و یه سالن دلپذیر می‌بینم.';
	end,
	used = function(s, w)
		if w == 'shotgun' then
			s._broken = true;
			ways():add('hall5');
			return 'هیهات... امیدوارم که آخریش باشه؟؟؟ یه تاب به شاتگانم می‌دم و شیشه رو خورد می‌کنم.';
		end
	end,
};

hall5 = room {
	nam = 'سالن',
	pic = 'gfx/hall5.png',
	enter = function(s, f)
		if f == 'krysha' then
			return 'می‌پرم توی سالن و اطراف رو نگاه می‌کنم...';
		end
	end,
	act = function(s, w)
		if w == 1 then
			return 'تجملات بی‌مصرف.';
		end
		if w == 2 then
			return 'روی سطح یکی از ستون‌ها دست می‌کشم... مرمره!';
		end
		if w == 3 then
			return 'به نظرم این چلچراغ از جنس کوارتزه.';
		end
		if w == 4 then
			return 'تاریک... اما... این دیگه چیه؟ انگار یه قطار رسید به محوطه پشتی موسسه.';
		end
		if w == 5 then
			return 'دونه‌های برف از توی پنجره‌ی شکسته فر می‌خورن.';
		end
		if w == 6 then
			if s.way:srch('escape3') then
				return walk('escape3');
			end
			return walk('gudlg');
		end
		if w == 7 then
			return 'این در بسته است. فکر نمی‌کنم بتونم با کلیدم بازش کنم.';
		end
		if w == 8 then
			return 'عجب... پیکاسو؟';
		end
		if w == 9 then
			return 'ضعف شدیدی همه وجودم رو گرفته... نه! نباید بخوابم...';
		end
	end,
	used = function(s, w, ww)
		return 'برای چی؟';
	end,
	dsc = 'سالن سترگ و باشکوه تقریبا بخش شمالی ساختمان رو اشغال کرده!',
	obj = {
		vobj(1,'carpet', 'پاهام عمق {فرش} مخمل قرمز رو حس می‌کنن.'),
		vobj(2,'columns', 'هشت ستون {مرمرین} یک دالان تشکیل دادن.'),
		vobj(3,'chandelier', '{چلچراغ} عظیم از سقف آویزونه.'),
		vobj(4,'east windows', 'چهار {پنجره} شرقی.'),
		vobj(5,'west windows', 'یه {پنجره} شکسته سمت چپ منه.'),
		vobj(6,'small door', 'در منتهی الیه شمالی سالن یک {در} کوچک چوبی می‌بینم.'),
		vobj(7,'entry door', '{درب} ورودی پشت سرمه.'),
		vobj(8,'paintings', '{نقاشی‌های} زیبای قاب شده به دیوارها آویخته شدن.'),
		vobj(9,'sofas', '{کاناپه‌های} نرم دورتادور محوطه قرار گرفتن.'),
	},
	way = { 'krysha' },
};

krysha = room {
	nam = 'سقف',
	pic = 'gfx/krysha.png',
	enter = function(s, f)
		return 'به سرعت به طرف پنجره شکسته می‌رم و در یه چشم برهم زدن روی سقف هستم...';
	end,
	dsc = [[
	ظاهرا طبقه پنجم بعد از ساخت چهار طبقه دیگر ساخته شده. با راه رفتن روی سقف می‌تونم به اولین پنجره‌های بخش‌های جنوبی و شمالی ساختمان برسم.
	]],
	obj = {'nwin', 'swin'},
	way = {'escape2'},
};

gudlg2 = dlg {
	nam = 'مرد توی پرتره',
	pic = 'gfx/pmanb.png',
	dsc = 'صورت آویزونش رو نگاه می‌کنم. به نظر آرومه.',
	obj = {
		[1] = phr('گرفتی، خُله؟',
		'جواب یه ناله است که به زحمت می‌شه شنید.',
		[[pon(1); back();]]),
		[2] = phr('اما چرا؟ چرا این بساط؟',
		'سرش رو بالا گرفت و به من نگاه کرد. - من فقط وظیفه‌ام رو انجام دادم...',
		[[pon(3);poff(1);]]),
		[3] = _phr('چه چرندیاتی؟',
		'- بعدش به هیچ دردی نمی‌خوردم... خوب - فکر کردم... - جهان باید تقاص این اشتباه رو پس بده...',
		[[pon(4)]]),
		[4] = _phr('چی می‌گی؟',
		'- به عنوان یک استاد کار می‌کردم... اما به هیچ دردی نمی‌خوردم... من... نمی‌تونستم این رو تحمل کنم...',
		[[pon(5)]]),
		[5] = _phr('چه آدم پستی...',
		'— اما مجبورشون می‌کنم... مجبورشون می‌کنم... من، من، من - من برای ابد زندگی می‌کنم... خودم... به تنهایی...',
		[[pon(6)]]),
		[6] = _phr('به نظرم دیوانه شدی...',
		'بدنش اون گوشه مثل توی سردی می‌لرزه.',
		[[pon(1); back()]]),
	}
};

gudlg = dlg {
	nam = 'مرد توی پرتره',
	pic = 'gfx/pman.png',
	enter = function(s)
		lifeoff('mycat');
		inv():del('shotgun');
		return [[
		عجیبه... در بسته نیست... با احتیاط در رو باز می‌کنم و وارد اتاق می‌شم.
		^^یکهو متوجه می‌شم که لوله‌ی یک هفت‌تیر توی صورتمه. - براوو، براوو! احسنت - مرد توی صندلی راحتی این رو می‌گه - صاحب هفت‌تیر. - مدت زیادی منتظرت بودم. تو همون جنگلبان هستی؟ خوب، بیا منتظر نگهبان‌ها باشیم. الان هم شاتگانت رو بنداز روی زمین. - کاری جز اطاعت ازم ساخته نیست.]];
	end,
	dsc = [[
	دارم صورتش رو می‌بینم - صورتی که توی تمام پرتره‌های آویزان شده از در و دیوار این ساختمان هست. صورت آرومیه و رد هیچ احساسی توش نیست. یه لبخند ملایم رو لبشه. باید وقت بخرم... پس ازش می‌پرسم:]],

	obj = {
	[1] = phr('گپ بزنیم؟',
	'عجب... در مورد چه چیزی می‌تونیم حرف بزنیم؟ چه صحبتی ممکنه بین من و یه... یه جنگلبان وجود داشته باشه؟',
	[[pon(2)]]),
	[2] = _phr('مثلا، اینکه آیا واقعا تفسیر اِوِرِت درست بود؟',
	[[
	- ها ها ها!!! - مرد توی پرتره‌ها لبخندی بی‌معنی می‌زنه، - البته که صحیح نیست... اون فقط یه قصه است واسه نادونها تا وادارشون کنه به جاودانگی خودشون ایمان بیارن... و ممکنه...
	]],
	[[pon(3)]] ),
	[3] = _phr('...که اینطور، پس اصلا هیچ اثبات علمی براش وجود نداره؟',
	[[
	مرد دست از خندیدن می‌کشه - ... و ممکنه... ممکنه که واقعا صحت داشته باشه؟ - مرد به شکل مرموزی اضافه می‌کنه. - پس چی درسته؟ تو چی فکر می‌کنی؟
	]],
	 [[pon(4)]]),
	[4] = _phr('می‌دونم که دروغه!',
	'آیا واقعا می‌دونی؟ - چشم‌های تهی به من نگاه می‌کنن - بلی یا خیر؟ - ناگهان وحشت من رو از پا می‌اندازه.'
	,[[pon(5,9)]]),
	[5] = _phr('یه دروغه!!!', 
	'اگه باشه چطور؟ تصور کن که باشه؟... تو یه هکری، مگه نه؟ تو دوست داری پیش‌بینی کنی و جلو جلو فکر کنی...',
[[pon(6);poff(9)]]),

	[6] = _phr('نه! امکان نداره که این راست باشه! اگه این راست باشه - اونوقت جهان دیر یا زود محکوم به فناست! اونوقت...',
	[[
	- بله، درست فهمیدی... اونوقت فقط تو وجود داری!!! به خودت گوش کن. چه کسی این پاسخ رو به تو داد؟ آیا همین رو آرزو نمی‌کنی؟ آیا منِ درونت این رو آرزو نمی‌کنه؟ - تو بینش عمیقش دارم فرو می‌ریزم.
	]],
	 [[pon(7)]]),
	[7] = _phr('اگه... اگه.. اونوقت چرا؟',
	[[
	- درسته... درسته... ـ مرد پرتره‌ها شیک و تر و تمیز می‌گه... یه موج وحشت دیگه من رو گیج می‌کنه... به زانو می‌افتم... قلبم دیوانه‌وار می‌تپه و داره از قفسه‌ی سینه‌ام بیرون می‌زنه...
	]],
	[[pon(8)]]),
	[8] = _phr('من نمی‌تونم... نه...',
	[[
	- و اگر همه اینها درست باشه، در اونصورت تو دلیلی برای ترسیدن نداری. - با خرخر می‌گه. قلبم تندتر می‌زنه. و دست آخر، سینه‌ام می‌ترکه و یه توپ نرم خز با پنجه‌هاش ازش مستقیم تو صورت مرد پرتره‌ها بیرون می‌جهه. صدای یه شلیک تو فضا طنین می‌اندازه. شونه‌ی چپم از درد تیر می‌کشه و هشیارم می‌کنه و می‌پرم روی پنجه‌هام و به طرف جلو خیزبرمی‌دارم...
	]],
	[[return walk('escape3')]]),
	[9] = _phr('بیا فرض کنیم که درست باشه.',
		'- خوب ... درسته... فکر کنم... فکر کنم تو یه هکری، درسته؟ ـ مرد توی پرتره‌ها تو گوشم زمزمه می‌کنه.',
		[[pon(6);poff(5)]])
	},
};

--shkf = obj {
--	nam = 'край шкафа',
--	inv = 'Я держу в руках край шкафа.',
--};

shkaf = obj {
	nam = 'قفسه کتاب',
	inv = 'گوشه‌ی قفسه‌ی کتاب‌ها رو با دست‌هام می‌گیرم.',
	dsc = function(s)
		if s._fall then
			return '{قفسه کتاب} راه در ورودی رو سد کرده.';
		end
		return 'یک {قفسه کتاب} کنار دره.';
	end,
	act = function(s)
		if not escape3._guards or s._fall then
			return 'چند کتاب در مورد فلسفه... و فیزیک.';
		end
		inv():add('shkaf');
		return 'گوشه‌ی قفسه کتاب رو محکم می‌گیرم.';
	end,
};

fromw5 = room {
	nam = 'روی آستانه‌ی پنجره',
	dsc = 'روی لبه‌ی پنجره می‌ایستم. باد سرد مانع تنفسم می‌شه.',
	pic = 'gfx/fromwin2.png',
	enter = 'خوب، امیدوارم که آخریش باشه...',
	act = function(s, w)
		if w == 1 then
			return walk('nwall');
		end
	end,
	obj = {
		vobj(1, 'drainpipe', 'به زحمت متوجه یه {ناودون} سمت راستم می‌شم.'),
	},
	way = { 'escape3' },
	exit = function(s, t)
		if t == 'escape3' then
			return 'باید عجله کنم!', false;
		end
	end
};

winr5 = obj {
	nam = 'پنجره',
	dsc = function(s)
		if s._broken then
			return 'باد زمستونی از توی {پنجره‌ی شکسته} می‌وزه.';
		else
			return 'یه {پنجره} رو به محوطه شمالی.';
		end
	end,
	act = function(s, w)
		if escape3._guards then
			if not shkaf._fall then
				return 'وقت لذت بردن از منظره نیست... باید نگهبان‌ها رو معطل کنم.';
			end
			if not have('mycat') then
				return 'بدون باریسک؟ ترجیح می‌دم باهم بمیریم.';
			end
--			if not have('revol') then
--				return 'Лучше поднять с пола пистолет, на всякий случай.';
--			end
			if s._broken then
				ways():add('fromw5');
				return walk('fromw5');
			else
				return 'پنجره بسته است.';
			end
		end
		escape3._guards = true;
		lifeon('escape3');
		return 	[[
	بیرون پنجره سیاهی مطلق حکمفرماست. به تاریکی خیره می‌شم اما بعدش پشت سرم صدای خفه‌ی کسی رو می‌شنوم... صدا از داخل سالن میاد. به نظرم نگهبان‌ها از قبل اینجان! باید کاری بکنم!
	]];
	end,
	used = function(s, w)
		if escape3._guards and not shkaf._fall then
			return 'وقتی نمونده... نگهبان‌ها بزودی می‌ریزن تو...';
		end
		if w == 'shotgun' then
			if not s._broken then
				s._broken = true;
				return 'بازم؟ چه کنیم... یه تاب به شاتگانم می‌دم و شیشه رو خرد می‌کنم. خرده‌شیشه‌ها پر می‌کشن به سوی تاریکی.';
			end
			return 'این پنجره قبلا شکسته.';
		end
	end,
};

revol = obj {
	nam = 'هفت‌تیر',
	dsc = '{هفت‌تیره} افتاده روی زمین.',
	inv = 'شش فشنگ.',
	tak = 'هفت‌تیر رو از روی زمین برمی‌دارم.',
};

escape3 = room {
	nam = 'داخل اتاق',
	pic = 'gfx/manroom.png',
	enter = function(s, f)
		if f == 'gudlg' then
			inv():del('mycat');
			hall5.way:add('escape3');
			return 	[[
	صدای افتادن یک تفنگ رو می‌شنوم... بعدش با تمام قوتم می‌کوبم تو صورت یکی. پشت سر هم. باریسک هی عقب و جلو می‌دوه و با نگرانی میو میو می‌کنه.
	]];
		end
	end,
	act = function(s, w)
		if w == 1 then
			return walk('gudlg2');
		end
		if w == 2 then
			return 'هنر انتزاعی راست کار من نیست.';
		end
		if w == 3 then
			local st = '';
			if shkaf._fall then
				st = 'قفسه‌کتاب جلوش رو گرفته.';
			end
			return 'در راهرو.'..st;
		end
	end,
	used = function(s, w, ww)
		if w == 1 and ww == 'shotgun' or ww == 'revol' then
			return 'بله - این شرارته. اما من نمی‌تونم به یه انسان بی‌دفاع شلیک کنم.';
		end
		if w == 3 and ww == 'shkaf' then
			shkaf._fall = true;
			inv():del('shkaf');
			return 'قفسه کتاب رو هل می‌دم و می‌افته روی زمین و جلوی در رو سد می‌کنه.';
		end
	end,
	dsc = [[
	توی یه اتاق کوچک و دنج هستم. یه میز وسط اتاقه. یه صندلی افتاده کنارش. یه لوستر کوچک فضا رو روشن کرده. دو تا قفسه کتاب کوچک سینه‌ی دیوارهاست.
	]],
	obj = {
		vobj(1, 'man', 	[[
	{مرد} توی پرتره‌ها نشسته روی زمین و به میز تکیه داده. قطرات خون از لبش پایین می‌چکه. ناله می‌کنه.
	]]),
		vobj(2, 'paintings', 'تعدادی {تابلو نقاشی} روی دیوارهاست.'),
		vobj(3, 'door', '{در} پشت سرمه.'),
		'revol',
		'shkaf',
		'shotgun',
		'mycat',
		'winr5',
	},
	life = function(s)
		if rnd(3) == 1 then
			return 'صدای چند شلیک می‌شنوم... گلوله‌ها از در رد می‌شن... باید کاری بکنم...';
		end
	end,
	exit = function(s,t)
		if t == 'hall5' then
			if shkaf._fall then
				return '{قفسه کتاب} راه عبور رو سد کرده.', false;
			end
			if s._guards then
				return 'اینجا تیر می‌خورم...', false;
			end
			s._guards = true;
			lifeon('escape3');
			return 	[[
	دارم به طرف سالن می‌رم که یکهو در طرف مخالف باز می‌شه و نگهبان‌ها می‌ریزن تو. به سرعت در رو می‌بندم.
	]], false;
		end
		lifeoff('escape3');
	end,
	way = {
		'hall5'
	},
};

nwall = room {
	nam = 'ضلع شمالی',
	dsc = 'کنار دیوار ضلع شمالی موسسه هستم.',
	pic = 'gfx/nside.png',
	way = {'eside2','wside' },
	act = function(s, w)
		if w == 1 then
			return 'بله - یه ناودون... به قدر کفایت مستحکم. اما گمان نمی‌کنم بتونم ازش بالا برم.';
		end
	end,
	enter = function(s, f)
		if f == 'fromw5' then
			return 	[[
	با غلبه به درد شونه‌ی چپم از آستانه پنجره می‌پرم و ناودون رو می‌گیرم... همینکه من و باریسک توی تاریکی زمستون سقوط می‌کنیم قلبم توی سینه دیوانه‌وار می‌تپه. اما یه لحظه بعد دارم از ناودون سر می‌خورم پایین و کف دست‌هام رو زخمی می‌کنم...
	]];
		end
	end,
	obj = { vobj(1, 'drainpipe',
		'{ناودون} در گوشه‌ی شرقی ساختمون امتداد داره.'
		)},
	exit = function(s, t)
		if t == 'wside' then
			if not s._guards then
				s._guards = true;
				return 	[[
	دور و بر گوشه ساختمون رو نگاه می‌کنم و نگهبان‌ها رو می‌بینم که از ایست بازرسی بیرون می‌دون و به طرف من میان. - اونجاست! - صدای فریادشون رو می‌شنوم... ترق ترق صدای شلیک باعث می‌شه عقب بکشم.
	]], false;
			end
			return 'من رو اونجا گیر می‌اندازن...', false;
		end
	end
};

eside2 = room {
	nam = 'پشت موسسه',
	pic = 'gfx/esidee.png',
	dsc = [[
	کنار دیوار پشتی موسسه هستم. خط راه‌آهن اینجاست.]],
	act = function(s,w)
		if w == 1 then
			return 'مسلسل‌ها به طرف ضلع جنوبی موسسه نشانه رفتن. بهتره تا می‌تونم ازشون دوری کنم.';
		end
		if w == 2 then
			return 'عجب... ظاهرا همون قطاره است. در موردش شنیدم... تخلیه بار هنوز شروع نشده. اما دروازه‌ها باز شدن.';
		end
		if w == 3 then
			return 'چهار وسیله نقلیه ریلی. از جنس لوکوموتیو - ChME3. کل قطار توی محوطه‌ی موسسه جا می‌شه.';
		end
	end,
	obj = {
	vobj(1,'gun towers', 'ورودی قطار توسط {برج‌های مسلسل} پوشش داده شده.'),
	vobj(3,'train', 'شبح سیاه یک {قطار} رو تشخیص می‌دم.'),
	vobj(2,'gates', '{دروازه‌های} بزرگ فلزی توی دیوارهای موسسه باز شدن. می‌بینم که نور از دروازه بیرون می‌پاشه.'),
	},
	exit = function(s, t)
		if t == 'sside' then
			return 'مسلسل‌های ضلع جنوبی نگرانم می‌کنن. خیلی خطرناکه.',
			false
		end
		if t == 'nwall' and nwall._guards then
			return 'راه برگشتی نیست...', false;
		end
	end,
	way = {'nwall','train','sside'},
};
function checkloc()
	if p1._off or p2._off then -- battary or switch off off
		p3._off = true;
		p4._off = true;
		p5._off = true;
--		p51._off = true;
--		p6._off = true;
	end
	if p3._off or p4._off then
--		p7._off = true;
--		p71._off = true;
	end
	if p5._off then
		p7._off = true;
	end
	if p51._off then
		p71._off = true;
	end
	if p6._off then
--		p7._off = true;
--		p71._off = true;
	end
	if p7._off then
--		p71._off = true;
	end
end

p1 = obj {
	_off = false,
	nam = 'سوئیچ',
	dsc = function(s)
		local st = 'روشن.';
		if s._off then
			st = 'خاموش.';
		end
		return '{کلید} قطع باطری وی‌بی: ' .. st;
	end,
	act = function(s)
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return 'در حال سوئیچ کردن...';
	end
};

p2 = obj {
	_off = true;
	nam = 'کلید',
	dsc = function(s)
		local st = 'رو به پایین.';
		if s._off then
			st = 'رو به بالا.';
		end
		return 'وضعیت دگمه سوئیچ {کلید}: '..st;
	end,
	act = function(s)
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return 'کلید رو می‌چرخونم.';
	end
};
p3 = obj {
	_off = true,
	nam = 'فشارسنج الکتریکی',
	dsc = function(s)
		local st = 'روشن.';
		if s._off then
			st = 'خاموش.';
		end
		return '{فشارسنج الکتریکی}: '..st;
	end,
	act = function(s)
		if p1._off or p2._off then
			return 'عجبیه... کار نمی‌کنه.'
		end
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return 'در حال سوئیچ کردن...'
	end
};

p4 = obj {
	_off = false,
	nam = 'دماسنج الکتریکی',
	dsc = function(s)
		local st = 'روشن.';
		if s._off then
			st = 'خاموش.';
		end
		return '{دماسنج الکتریکی}: '..st;
	end,
	act = function(s)
		if p1._off or p2._off then
			return 'عجبیه... کار نمی‌کنه.'
		end
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return 'در حال سوئیچ کردن...'
	end
};

p5 = obj {
	_off = true,
	nam = 'دومین پمپ بخش',
	dsc = function(s)
		local st = 'روشن.';
		if s._off then
			st = 'خاموش.';
		end
		return 'دومین {پمپ} سوخت بخش: '..st;
	end,
	act = function(s)
		if p1._off or p2._off then
			return 'عجبیه... کار نمی‌کنه.'
		end
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return 'در حال سوئیچ کردن...'
	end
};

p6 = obj {
	_off = true,
	nam = 'کنترل',
	dsc = function(s)
		local st = 'روشن.';
		if s._off then
			st = 'خاموش.';
		end
		return '{کنترل}: '..st;
	end,
	act = function(s)
		if p1._off or p2._off then
			return 'عجبیه... کار نمی‌کنه.'
		end
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return 'در حال سوئیچ کردن...'
	end
};

p7 = obj {
	_off = true,
	nam = 'استارت دومین موتور دیزل بخش',
	dsc = function(s)
		local st = 'روشن.';
		if s._off then
			st = 'خاموش.';
		end
		return 'وضعیت {استارت} دومین موتور دیزل بخش: '..st;
	end,
	act = function(s)
		if p3._off or p4._off or p5._off or p6._off then
			return 'عجبیه... کار نمی‌کنه.'
		end
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return 'در حال سوئیچ کردن...'
	end
};

p51 = obj {
	_off = true,
	nam = 'اولین پمپ بخش',
	dsc = function(s)
		local st = 'روشن.';
		if s._off then
			st = 'خاموش.';
		end
		return 'وضعیت اولین {پمپ} بخش: '..st;
	end,
	act = function(s)
		if p1._off or p2._off then
			return 'عجبیه... کار نمی‌کنه.'
		end
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return 'در حال سوئیچ کردن...'
	end
};

p71 = obj {
	_off = true,
	nam = 'استارت دیزل بخش اول',
	dsc = function(s)
		local st = 'روشن.';
		if s._off then
			st = 'خاموش.';
		end
		return '{استارت} موتور دیزل بخش اول: '..st;
	end,
	act = function(s)
		if p3._off or p4._off or p5._off or p6._off or p7._off then
			return 'عجیبه... کار نمی‌کنه.'
		end
		if s._off then
			s._off = false;
		else
			s._off = true;
		end
		checkloc();
		return 'در حال سوئیچ کردن...'
	end
};

p8 = obj {
	_num = 1,
	nam = 'معکوس کننده',
	dsc = function(s)
		local st;
		if s._num == 1 then
			st = 'خنثی.';
		elseif s._num == 2 then
			st = 'به پس.';
		elseif s._num == 3 then
			st = 'به پیش.';
		end
		return '{دسته‌ی} معکوس کننده: ' .. st;
	end,
	act = function(s)
		s._num = s._num + 1;
		if s._num == 4 then
			s._num = 1;
		end
		return 'در حال سوئیچ کردن...'
	end
};

p9 = obj {
	_num = 1,
	nam = 'کنترلر',
	dsc = function(s)
		local st;
		if s._num == 1 then
			st = '0.';
		elseif s._num == 2 then
			st = '1.';
		elseif s._num == 3 then
			st = '2.';
		end
		return 'دسته‌ی {کنترلر}: '..st;
	end,
	act = function(s)
		s._num = s._num + 1;
		if s._num == 4 then
			s._num = 1;
		end
		if s._num == 1 then
			return 'در حال سوئیچ کردن...'
		end
		if not p71._off and not p7._off then
			if p8._num == 2 then
				s._num = 1;
				return 'لوکوموتیو می‌لرزه و شروع به عقب رفتن می‌کنه. کنترلر رو روی صفر تنظیم می‌کنم.';
			elseif p8._num == 3 then
				lifeoff('mycat');
				set_music('mus/liberty.s3m');
				return walk('theend');
			end
		end
		s._num = 1;
		return 'هیچ اتفاقی نمی‌افته... کنترلر رو روی صفر تنظیم می‌کنم.';
	end
};
	
train = room {
	nam = function(s)
		if here() == train then
			return 'داخل لوکوموتیو';
		end
		return 'به طرف قطار';
	end,
	pic = 'gfx/cab.png',
	dsc = 'خوب، من داخل لوکوموتیو هستم. بدنه‌ی ضخیم فلزی من رو از گلوله‌ها محافظت می‌کنه. اتاق مهندسی ظاهرا به حال خودش رها شده. کلی تجهیزات و کنترل می‌بینم.',
	act = function(s, w)
		if w == 2 then
			if p1._off or p2._off then
				return 'دگمه‌ی شیپور رو فشار می‌دم، اما صدایی نمی‌شنوم.';
			end
			return 'یه سوت بی‌حال می‌شنوم. من یه مهندس راه‌آهنم!';
		end
		if w == 1 then
			return 'جدی جدی باید این وسیله رو روشن کنم... و هیچ دروازه‌ای سد راهم نخواهد شد.';
		end
	end,
	life = function(s)
		local st = '';
		if not p7._off or not p71._off then
			st = 'قشنگ حس می‌کنم که لوکوموتیو چطور مرتعش می‌شه. موتور دیزلی داره کار می‌کنه. ';
		end
		if rnd(10) < 5 then
			st = st..'صدای برخورد گلوله‌ها به بدنه‌ی فلزی رو می‌شنوم.';
		end
		return st;
	end,
	exit = function(s,t)
		if t == 'eside2' then
			return 'نه... بهتره همینجا بمونم. تا آخرین نفس ایستادگی می‌کنیم.',
				false;
		end
		lifeoff('train');
	end,
	enter = function(s, f)
		if f == 'eside2' and not guards1._broken then 
			return cat('همینکه سرم رو می‌دزم به طرف قطار می‌دوم.^^', 
				walk('vorota')), false;
		end
		lifeon('train');
		set_music('mus/hispeed.s3m');
		return [[
		همینکه سرم رو می‌دزم به طرف قطار می‌دوم... از ماشین‌ها که رد می‌شم موفق می‌شم که تابلو رو بخونم: «هشدار! تشعشع بالا». یه کم دیگه می‌دوم و می‌رسم به لوکوموتیو. صدای شلیک گلوله‌ها پشت سرم رو می‌شنوم. مسلسل‌های روی برجک‌ها دارن به طرف من می‌چرخن. در سنگین رو باز می‌کنم و... داخل هستم!
		]]
	end,
	obj = {
		'p2', 'p1', 'p4', 'p3',  'p71','p51', 'p7', 'p5', 'p9', 'p8', 'p6',
		vobj(2, 'horn', '{شیپور} لوکوموتیو.');
		vobj(1, 'window', 'دروازه‌های بسته رو از توی {پنجره‌ها} می‌بینم.'),
	},
	way = { 'eside2' },
};

guards1 = obj {
	nam = 'guards',
	dsc = function(s, w)
		if s._broken then
			return '{نگهبان‌های} کنار گیت‌ها سعی می‌کنن که از زیر چلچراغ فروافتاده رد بشن.';
		end
		if s._shoot then
			return '{نگهبان‌ها} رو می‌بینم که از ترس شلیک‌های من پشت گیت‌ها پناه گرفتن.';
		end
		return '{نگهبان‌ها} رو با مسلسل می‌بینم که دارن از طریق سالن اول به طرفم میان.';
	end,
	act = function(s, w)
		if s._broken then
			return 'ظاهرا شوکه شدن...';
		end
		if s._shoot then
			return 'چه حرومزاده‌ای!';
		end
		return 'شگفت‌آوره که هنوز زنده‌ام...';
	end,
	used = function(s, w)
		if w == 'shotgun' or w == 'revol' then
			if s._shoot then
				return 'بیهوده است. نگهبان‌ها پشت گیت‌های فلزی پناه گرفتن.';
			end
			s._shoot = true;
			return 'از دیوار بیرون رو نگاه می‌کنم و همینطوری چند بار شلیک می‌کنم.';
		end
	end,
};

lustra1 = obj {
	nam = 'چلچراغ‌ها',
	dsc = function(s, w)
		if s._broken then
			return '{چلچراغ} از سقف آویزونه.';
		end
		return 'دو تا {چلچراغ} پر زرق و برق از سقف آویزونه.';
	end,
	act = function(s, w)
		if guards1._shoot then
			return 'یکی از چلچراغ‌ها درست بالای گیت‌هاست.';
		end
		return 'نمی‌تونم نگاه ازشون وردارم... شاید از کریستال ساخته شدن؟';
	end,
	used = function(s, w)
		if w == 'revol' then
			return 'شک دارم که این هفت‌تیر صدمه‌ی قابل توجهی به چلچراغ‌ها بزنه.';
		end
		if w == 'shotgun' then
			shotgun._unloaded = true;
			s._broken = true;
			guards1._broken = true;
			lifeoff('vorota');
			drop('shotgun');
			return [[
			از دیوار بیرون رو نگاه می‌کنم و با شاتگان شلیک می‌کنم. صدای شلیک و یه برخورد شدید گوشم رو کر می‌کنه. یکی از چلچراغ‌ها رو می‌بینم که داره از سقف کنده می‌شه و پایین روی سر نگهبان‌هایی که دارند فریاد می‌کشن می‌افته. شاتگان بی‌مصرف و خالی رو دور می‌اندازم.
			]];
		end
	end,
	
};

vorota = room {
	nam = 'نزدیک گیت‌ها',
	pic = 'gfx/shooting.png',
	enter = function(s, f)
		if f == 'eside2' and not guards1._broken then
			lifeon('vorota');
			return 'با رسیدن به گیت‌ها ترق ترق صدای شلیک می‌شنونم و خودم رو به دیوار می‌چسبونم.';
		end
	end,
	life = function(s)
		if rnd(6) < 4 then
			return 'صدای شلیک طنین می‌اندازه تو فضا. خودم رو می‌چسبونم به دیوار.';
		end 
	end,
	act = function(s, w)
		if w == 1 then
			return 'اون گیت‌ها من رو امروز راه دادن داخل. الان دارم از اونطرف می‌بینمشون.';
		end
	end,
	dsc = 'کنار گیت‌های باز هستم. اونها راه رو به طرف طبقه اول موسسه باز می‌کنن.',
	obj = {
	vobj(1, 'tourniquets', 'ردیف {گیت‌ها} رو می‌بینم.'),
	'lustra1',
	'guards1',
	},
	exit = function(s, t)
		if not guards1._broken and t == 'train' then
			return 'خیز برمی‌دارم به جلو اما شلیک‌های مسلسل من رو به عقب می‌فرستن.',
			false;
		end
	end,
	way = { 'train', 'eside2' },
};

theend = room {
	nam = 'گفتار پایانی',
	pic = 'gfx/chme3.png',
	dsc = [[
	دسته‌ی کنترلر رو تا آخر می‌دم جلو و لوکوموتیو می‌لرزه و راه می‌افته به طرف جلو. صدای فریاد شنیدم و رگبار مسلسل با جدیتی نو شروع کرد به سوراخ سوراخ کردن دیواره‌های کابین... اما قطار سریع‌تر و سریع‌تر حرکت کرد. و در فاصله‌ای کوتاه یه برخورد مهیب روی داد! از دروازه‌هایی بود که توان ایستادگی در برابر ۱۳۵۰ اسب بخار قدرت لوکوموتیو من رو نداشتن! از لولاهاشون کنده شدن و ده‌ها متر روی ریل‌ها کشیده شدن...^^

باریسک صورتش رو بیرون آورد و اطراف رو نگاه کرد. گوش‌هاش رو نوازش کردم، همونطوری که همیشه می‌کنم. وقتی که صدای شلیک محو شده بود، از پنجره به بیرون نگاه کردم و موسسه رو برای بار آخر دیدم. مثل یک مشعل داشت می‌سوخت. آتش به تمام محوطه‌ی طبقه‌ی پنجم سرایت کرده بود. به آسمان نگاه کردم... و حالا - تقریبا در تاریکی مطلق - می‌تونستم میلیونها ستاره‌ی رخشان الماس‌وار رو ببینم.^^

خیلی زود زمین‌های اطراف به تایگا منتهی شدن و من می‌تونستم خط افق دوستانه‌ی درختان کاج و صنوبر رو در حالی که هی جا عوض می‌کردن در پس زمینه‌ی ریتم صدای گردش چرخ‌ها ببینم. زخم شونه‌ام خیلی آزارم می‌داد و حس می‌کردم چقدر خسته‌ام... نشستم روی زمین و به بدنه سرد فلزی کابین تکیه دادم. به آوای لوکوموتیو گوش می‌دادم و باریسکم رو نوازش می‌کردم...^^

باریسک با چشم‌های زیرکش نگاهم کرد و طوری پِرر پِرر کرد انگار که از من سوالی می‌پرسید. - برمی‌گردیم خونه... - و من جوابش رو دادم - داریم برمی‌گردیم خونه...^^

پایان^^

 ---^^

ترجمه فارسی و فارسی‌سازی موتور بازی: مِهدی صادقی - اکتبر ۲۰۲۰^^

The Story and the INSTEAD Engine: ^
Peter Kosyh a.k.a. gl00my // 2009^^

Graphics: ^
Peter Kosyh, some photos are taken from open sources.^^

Music: ^
One fine day // Elwood^
Revelation // necros^
New beginning // Purple Motion^
Ice frontier // Skaven^
Planete football // Frank Amoros^
Underwater world II // Slightly Magic^
Hybrid song // Quazar^
Hispeed - track whatever // Purple Motion^
Liberty // Zapper^^

Testers:^
Sergey Kalichev a.k.a. Pkun^
Vladimir Podobaev a.k.a. zloyvov^^

English Translation:^
Episode 1: tkzv^
Episodes 2 and 3: Vladimir Podobaev^^

If you like the game, the best what you can do - is to write your own history on the INSTEAD engine. :)^^

Acknowledgments:^
To all who haven't been bothering me. :)^^
]],
};

